
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <math.h>
#include <stdio.h>
#include <limits>
#include <bitset>

using namespace std;

vector<int> makeCycle (vector<int> visitedCities, int visitedCitiesSize, int n, int startCity, map<int, vector<int>> citiesRoads) {
    visitedCities.push_back(startCity);
    visitedCitiesSize++;

    if (visitedCitiesSize == n) {
        if (find(citiesRoads[startCity].begin(), citiesRoads[startCity].end(), 1) != citiesRoads[startCity].end()) {
            visitedCities.push_back(1);
            return visitedCities;
        }
        return { -1 };
    }

    for (int city : citiesRoads[startCity]) {
        if (find(visitedCities.begin(), visitedCities.end(), city) == visitedCities.end()) {
            vector<int> cycle = makeCycle(visitedCities, visitedCitiesSize, n, city, citiesRoads);
            if (cycle[0] != -1) {
                return cycle;
            }
        }
    }

    return { -1 };
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    
    int n, m;
    cin >> n >> m;

    map<int, vector<int>> citiesRoads;

    vector<vector<int>> roads(m);

    int j = 0;

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        citiesRoads[a].push_back(b);
    }


    vector<int> result = {-1};
    for (int city : citiesRoads[1]) {
        vector<int> cycle = makeCycle({}, 0, n, 1, citiesRoads);
        if (cycle[0] != -1) {
            result = cycle;
        }
    }

    if (result[0] == -1) {
        printf("NO");
        return 0;
    }
    printf("YES\n");
    for (int c : result) {
        printf("%i ", c);
    }

    
    
}
